import { View, Text, ScrollView, TextInput, Pressable, StyleSheet } from "react-native";
import React from "react";
import MenuNavigation from "../Utilities/CustomHeader/MenuNavigation";
import { ProfileStyles } from "../Profile/ProfileStyle";
import CommonStyles from "../Utilities/CommonStyles/CommonStyles";
import dpr from "../Utilities/CustomStyleAttribute/dpr";
import Rocket from "../../assets/svgs/trackOrder/rocket.svg";
import { trackOrderStyle } from "./trackOrderStyle";

import { useState } from "react";
import CustomSpinner from "../Utilities/CustomSpinner/CustomSpinner";
import { useDispatch } from "react-redux";
import { getTrackOrders } from "../../redux/slices/trackOrder/getTrackOrder";
import { getAllOrderStatus } from "../../redux/slices/trackOrder/getAllStatus";
import { BASE_API_URL_STG } from "@env";
import useCustomToast from "../../hooks/useCustomToast";
import useLangTranslation from "../../hooks/useLangTranslation";
import CustomSVG from "../../src/components/CustomSVG/CustomSVG";

const TrackOrderInput = (props) => {
    const { trans } = useLangTranslation();
    const [trackValue, setTrackValue] = useState("");
    const [error, setError] = useState("");
    const [requestLoad, setRequestLoad] = useState(false);
    const dispatch = useDispatch();
    const showToast = useCustomToast();

    const handleTrackOrder = async () => {
        if (trackValue) {
            setError(false);
            const TrackURL = `${BASE_API_URL_STG}/user/track-order/${trackValue}`;
            const StatusURL = `${BASE_API_URL_STG}/user/orders/statuses`;
            setRequestLoad(true);
            const trackOrder = await dispatch(
                getTrackOrders({ URL: TrackURL })
            );

            const status = await dispatch(
                getAllOrderStatus({ URL: StatusURL })
            );
            const {
                status: returnTrackOrderStatus,
                records: returnTrackOrderData,
            } = trackOrder?.payload;
            const {
                status: returnAllPossibleStatus,
                records: returnStatusData,
            } = status?.payload;
            setRequestLoad(false);
            if (
                returnTrackOrderStatus?.code === 200 &&
                returnAllPossibleStatus?.code === 200
            ) {
                setError(false);
                setTrackValue("");
                props.navigation.navigate("track order", {
                    myTrackOrders: returnTrackOrderData?.data,
                    allStatus: returnStatusData?.data,
                });
            } else {
                setError(true);
                showToast({
                    text1: trans(returnTrackOrderStatus?.message),
                    type: "common",
                    position: "bottom",
                    props: { variant: "error" },
                });
            }
        } else {
            setError(true);
        }
    };

    const styles = Styles(error);

    return (
        <View style={CommonStyles.cont}>
            <MenuNavigation
                navigationProps={props.navigation}
                routeName={trans("Track your order")}
            />
            <View style={ProfileStyles.hrLine} />
            <ScrollView
                keyboardShouldPersistTaps='always'
                style={CommonStyles.globalContainer}
            >
                <View style={trackOrderStyle.orderRocketSvg}>
                    <CustomSVG svgIcon={Rocket} />
                </View>
                <View>
                    <Text style={trackOrderStyle.orderHeader}>
                        {trans("Have An Order")}?
                    </Text>
                    <Text style={trackOrderStyle.orderDesc}>
                        {trans("Enter the track code of your order below and know the progress of your order delivery")}{" "}
                    </Text>
                </View>
                <View>
                    <TextInput
                        style={[trackOrderStyle.textInput, styles.textInput]}
                        value={trackValue}
                        onChangeText={setTrackValue}
                        placeholder={trans('e.g. VKADYFBOV7')}
                        keyboardType='default'
                    />
                </View>
                <View>
                    <Pressable
                        style={trackOrderStyle.trackOrderButton}
                        onPress={handleTrackOrder}
                        disabled={requestLoad}
                    >
                        {requestLoad ? (
                            <CustomSpinner
                                filePath={require("../../assets/lottie/loader2.json")}
                                size={{
                                    width: dpr(55),
                                    height: dpr(55),
                                }}
                            />
                        ) : (
                            <Text style={trackOrderStyle.trackOrderButtonText}>
                                {trans("Track Now")}
                            </Text>
                        )}
                    </Pressable>
                </View>
            </ScrollView>
        </View>
    );
};

export default TrackOrderInput;

const Styles = (error) => StyleSheet.create({
    textInput: {
        borderColor: error ? "#E43147" : "#DFDFDF"
    }
});